# -*- coding: utf-8 -*-
"""
Created on Tue Apr 20 10:35:41 2021

@author: Dyrvik
"""
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.cm as cm
import matplotlib as mpl
import seaborn as sns
import pandas as pd
import os

"""Colourmaps"""
CM_SUBSECTION_GREENS = np.linspace(0.4, 1.0, 1000) 
COLOURS_GREENS = [ cm.Greens(x) for x in CM_SUBSECTION_GREENS ]

"""File handling"""
main_folder_path = os.path.dirname(os.path.abspath(__file__))
main_folder_path = '\\\\?\\' + main_folder_path
data_folder_name = 'Selected files median'
data_folder_path = os.path.join(main_folder_path,data_folder_name)
export_folder_path = main_folder_path
# =============================================================================
# export_folder_name = 'Plots'
# export_folder_path = os.path.join(main_folder_path,export_folder_name)
# if not os.path.exists(export_folder_path):
#     os.mkdir(export_folder_path) # create folder if non-existent
# =============================================================================

selected_files = ['dyrvik_IGLED19-Batch 17_003C59-normal_2_2.ilv', \
                 'dyrvik_IGLED19-Batch 17_003C5B-normal_8_2.ilv', \
                 'dyrvik_IGLED19-Batch 17_003C5C-normal_8_2.ilv', \
                 'dyrvik_IGLED19-Batch 22_0040AD-rotated_6_2.ilv']

"""Some constants for graphical settings"""
lw = 3
ticksize_major = 8
ticksize_minor = 8  
    
"""Prepare plots"""
label_strings = ['1.6 nm',\
                 '3.3 nm',\
                 '11 nm',\
                 '20 nm']      
    
colour_array =  np.linspace(0, 999, len(selected_files))

fig = plt.figure(0)
fig.set_size_inches(9,8)
fig.set_tight_layout(True)
ax = plt.gca()
ax.set_xlabel('Current Density [$\mathregular{mA/cm^2}$]')
ax.set_ylabel('EQE [%]')

for i in range(len(selected_files)):
    """Load data and remove negatives to allow log-plots"""
    file_path = os.path.join(data_folder_path,selected_files[i])
    df = pd.read_csv(file_path,delimiter='\t')
    
    """Plot the data"""
    df['LED current [mA/cm2]'][df['LED current [mA/cm2]'] < 0] = np.nan
    ax.semilogx(df['LED current [mA/cm2]'], df['EQE [%]'], color=COLOURS_GREENS[int(colour_array[i])], label=label_strings[i])
    
"""Axis settings"""
ax.set_xlim(left=6e-2)
ax.set_ylim(bottom = 0)
ax.yaxis.set_major_locator(mpl.ticker.MultipleLocator(2))
ax.yaxis.set_minor_locator(mpl.ticker.MultipleLocator(1))

"""Annotation"""
ax.text(0.05, 0.95, 'Without $\mathrm{Al_2O_3}$',
        horizontalalignment='left',
        verticalalignment='top',
        transform=ax.transAxes)

"""Legend"""
leg = ax.legend(frameon=False,loc='lower right')

# Right-aligning the legend
vp = leg._legend_box._children[-1]._children[0]
for c in vp._children:
    c._children.reverse()
vp.align="right"

"""Graphical details"""
plt.rcParams['font.size'] = 24
plt.rc('axes', labelsize=30)    # fontsize of the x and y labels
plt.rcParams['axes.linewidth'] = lw
plt.rcParams['lines.linewidth'] = lw*1.5

ax.xaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax.xaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)
ax.yaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax.yaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)

"""Exporting plots"""
export_name = 'Plot'
plot_name = ' EQE(J) TFB thickness no Al2O3'
export_name_pdf = export_name + plot_name + '.pdf'
export_name_svg = export_name + plot_name + '.svg'
export_name_png = export_name + plot_name + '.png'
pdf_path = os.path.join(export_folder_path,export_name_pdf)
svg_path = os.path.join(export_folder_path,export_name_svg)
png_path = os.path.join(export_folder_path,export_name_png)
if len(pdf_path) > 255:
    warning_string = 'Warning: plot file path longer than 255 characters, downstream handling issues may occur. Path: ' + pdf_path
    print(warning_string)
fig.savefig(pdf_path)
fig.savefig(svg_path)
fig.savefig(png_path)
plt.close(fig)

